% Figures_11_12.m
% 
% counterfactuals figures
% 
% "The Past and Future of U.S. Structural Change" 
% Andrew Foerster, Andreas Hornstein, Pierre-Daniel Sarte, Mark Watson
% September 2025
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % 

% -- Clear Workspace -- %
restoredefaultpath;
clear;
clc;
close all;

% -- File Directories -- % 
datadir = 'Data\DataReplication\DataFinal\'; 
outdir  = 'Tables\';
figdir  = 'Figures\';
% figdir  = 'Figures\Robustness\LL_'; warning('Low Elasticity Results'); pause
% figdir  = 'Figures\Robustness\HH_'; warning('High Elasticity Results'); pause
matdir  = 'Output\';

% -- Add paths -- %
addpath('Functions\');
addpath('Utilities\')
addpath('Data\')

% -- Options -- %
format short
options = optimset('Display','off');
disp_code = 0;  % not displaying convergence every iteration
T = 72; 
nS = 5;

load_data;

n_counter_type  = 7;
va_share_model  = NaN(nS,T,n_counter_type);
va_share_data   = NaN(nS,T,n_counter_type);
theta_model     = NaN(nS,T,n_counter_type);
Phi_model       = NaN(nS,nS,T,n_counter_type);
gamma_model     = NaN(nS,T,n_counter_type);
Omega_model     = NaN(nS,nS,T,n_counter_type);
psix_model      = NaN(nS,T,n_counter_type);
psi_model       = NaN(nS,T,n_counter_type);
py_model        = NaN(nS,T,n_counter_type);
pv_model        = NaN(nS,T,n_counter_type);
v_model         = NaN(nS,T,n_counter_type);
l_model         = NaN(nS,T,n_counter_type);
w_model         = NaN(nS,T,n_counter_type);

%% counterfactual initial preference shocks for CES preferences
% adjust [Theta_c(5),rho] to maintain (e,s_c)-equilibrium with CES pref
% epsilon_c(5)=1

tt=1;

load([matdir 'driving_processes.mat'],'trend_labor')
l=trend_labor(tt,:)';

model=model_setup(tt);
ind1_c   = model.ind1_c;
ind2_c   = model.ind2_c;
Theta_c  = model.Theta_c;
epsilon_c= model.epsilon_c;
sigma    = model.sigma;
zeta_c   = model.zeta_c;
gamma_l  = model.gamma_l;

equilibrium= load([matdir 'model_output']);
w =equilibrium.w_model(tt,:)';
py=equilibrium.py_model(tt,:)';
ck=equilibrium.ck_model(tt,:)';
cn=equilibrium.cn_model(tt,:)';
e =equilibrium.e_model(tt,:)';
en=equilibrium.en_model(tt,:)';
ek=e-en;
s_c=1-en/e;

% Theta(SVC,1) with epsilon_c(SVC)=1
Theta_c5_CES=Theta_c(5)*cn^( (1-sigma)*(epsilon_c(5)-1) );    
% STEP 19: obtain rho
Theta_c(5)=Theta_c5_CES;
epsilon_c(5)=1;
etaEn_num = sum(epsilon_c(ind2_c).*Theta_c(ind2_c).*py(ind2_c).^(1-sigma).*cn.^(epsilon_c(ind2_c)*(1-sigma)));
etaEn_den = sum(Theta_c(ind2_c).*py(ind2_c).^(1-sigma).*cn.^(epsilon_c(ind2_c)*(1-sigma)));
etaEn = etaEn_num/etaEn_den;
rho_CES= s_c/((1-s_c)*etaEn + s_c);
% STEP 20: obtain lambda_c
pcn = prod(py(ind1_c).^zeta_c(ind1_c));
lambda_c = rho_CES/pcn*(cn/ck)^(1-rho_CES);
% STEP 21: obtain varphi
varphi_CES = lambda_c*(w./(l.^gamma_l))';

%% counterfactuals
for counter_type = 1:n_counter_type
    model_output    = load([matdir 'model_output']);
    py_lambda_guess = [model_output.py_model(1,:) model_output.lambdac_model(1)];
    trend_py = model_output.trend_py;

    for tt = 1:T
        disp(['t = ' num2str(tt)]);
        disp(' ')
        disp(' ')
        
        % -- Setting Up Model Parameters and Driving Processes -- %
        model = model_setup(tt);
        ind1_inv = model.ind1_inv;
        ind1_mat = model.ind1_mat;

        drv_proc    = load([matdir 'driving_processes.mat']);
        load([matdir 'psi_process.mat'],'psi_nxg_trend')
        load([matdir 'tfp_process.mat'],'trend_tfp')
        varphi          = model_output.varphi_model(tt,:);
        rho             = model_output.rho_model(tt);
        
        if counter_type == 1
            model.Theta_c(5)            = drv_proc.trend_Theta_t(1);
            psi_nxg_trend(tt,:)         = psi_nxg_trend(1,:);
            trend_tfp(tt,:)             = trend_tfp(1,:);
            varphi                      = model_output.varphi_model(1,:);
            rho                         = model_output.rho_model(1);
            model.eta_x(ind1_inv(1),:)  = drv_proc.trend_eta_x(1,:);      
            model.eta_x(ind1_inv(2),:)  = 1- drv_proc.trend_eta_x(1,:);   
            model.eta_m(ind1_mat(1),:)  = drv_proc.trend_eta_m(1,:);      
            model.eta_m(ind1_mat(2),:)  = 1-drv_proc.trend_eta_m(1,:);    
            counter_name                = 'nochange';
        elseif counter_type == 2
            model.Theta_c(5)            = drv_proc.trend_Theta_t(1);
            psi_nxg_trend(tt,:)             = psi_nxg_trend(1,:);
            varphi                      = model_output.varphi_model(1,:);
            rho                         = model_output.rho_model(1);
            model.eta_x(ind1_inv(1),:)  = drv_proc.trend_eta_x(1,:);      
            model.eta_x(ind1_inv(2),:)  = 1- drv_proc.trend_eta_x(1,:);   
            model.eta_m(ind1_mat(1),:)  = drv_proc.trend_eta_m(1,:);      
            model.eta_m(ind1_mat(2),:)  = 1-drv_proc.trend_eta_m(1,:);    
            counter_name                = 'tfp';
       elseif counter_type == 3
            model.Theta_c(5)            = drv_proc.trend_Theta_t(1);
            psi_nxg_trend(tt,:)             = psi_nxg_trend(1,:);
            varphi                      = model_output.varphi_model(1,:);
            rho                         = model_output.rho_model(1);
            counter_name                = 'tfp+ibtc';
        elseif counter_type == 4
            varphi                      = model_output.varphi_model(1,:);
            psi_nxg_trend(tt,:)             = psi_nxg_trend(1,:)';
            counter_name                = 'tfp+ibtc+pref';
        elseif counter_type == 5
            psi_nxg_trend(tt,:)             = psi_nxg_trend(1,:)';
            counter_name                = 'tfp+ibtc+pref+labor';
        elseif counter_type == 6
            counter_name                = 'fullmodel';            
        elseif counter_type == 7
            model.Theta_c(5)            = Theta_c5_CES;
            model.epsilon_c(5)          = 1.0;
            rho                         = rho_CES;
            varphi                      = varphi_CES;
            psi_nxg_trend(tt,:)             = psi_nxg_trend(1,:);
            model.eta_x(ind1_inv(1),:)  = drv_proc.trend_eta_x(1,:);      
            model.eta_x(ind1_inv(2),:)  = 1- drv_proc.trend_eta_x(1,:);   
            model.eta_m(ind1_mat(1),:)  = drv_proc.trend_eta_m(1,:);      
            model.eta_m(ind1_mat(2),:)  = 1-drv_proc.trend_eta_m(1,:);
            counter_name                = 'homo+tfp';
        end
       
        % -- Solve for the Equilibrium -- %
        [equilibrium,retcode] = fcn_steps_solver_endolabor(varphi',rho,disp_code,py_lambda_guess',trend_tfp(tt,:)',psi_nxg_trend(tt,:)',model);

        % -- Outputs from procedure -- %
        py  = equilibrium.py;
        pv  = equilibrium.pv;
        px  = equilibrium.px;
        pm  = equilibrium.pm;
        y   = equilibrium.y;
        v   = equilibrium.v;
        xij = equilibrium.xij;
        x   = equilibrium.x;
        mij = equilibrium.mij;
        m   = equilibrium.m;
        c   = equilibrium.c;
        cn  = equilibrium.cn;
        e   = equilibrium.e;
        psi = equilibrium.psi;
        z   = equilibrium.z;
        l   = equilibrium.l;
        lambda = equilibrium.lambdac;
    
        disp('Model Consistency Checks:')
        ind1_inv    = model.ind1_inv;
        ind2_inv    = model.ind2_inv;
        eta_x       = model.eta_x;
        epsilon_x   = model.epsilon_x;
        rho_x       = model.rho_x;
        zeta_x      = model.zeta_x;
        ind1_mat    = model.ind1_mat;
        ind2_mat    = model.ind2_mat;
        eta_m       = model.eta_m;
        epsilon_m   = model.epsilon_m;
        rho_m       = model.rho_m;
        zeta_m      = model.zeta_m;
        gamma_y     = model.gamma_y;
        beta        = model.beta;
        delta       = model.delta;
        alpha       = model.alpha;
        % s_c         = model.s_c;
        ind1_c      = model.ind1_c;
        ind2_c      = model.ind2_c;
        zeta_c      = model.zeta_c;
        Theta_c     = model.Theta_c;
        epsilon_c   = model.epsilon_c;
        sigma       = model.sigma;
        gamma_l     = model.gamma_l;
        
        % -- Investment Input Shares -- %
        inv_input_shares_model          = NaN(nS,nS);
        Omega_model_direct              = NaN(nS,nS);
        for j = 1:nS
            for i = 1:nS
                Omega_model_direct(i,j) = py(i)*xij(i,j)/px(j)/x(j);
            end
            for i = ind1_inv
                xkj = sum(eta_x(ind1_inv,j).*xij(ind1_inv,j).^((epsilon_x(j)-1)/epsilon_x(j))).^(epsilon_x(j)/(epsilon_x(j)-1));
                inv_input_shares_model(i,j)  = xkj^((1-epsilon_x(j))/epsilon_x(j))*xij(i,j)^((epsilon_x(j)-1)/epsilon_x(j))*eta_x(i,j)*rho_x(j);
            end
            for i = ind2_inv
                inv_input_shares_model(i,j)  = zeta_x(i,j)*(1-rho_x(j));
            end
        end
        inv_share_check = norm(inv_input_shares_model-Omega_model_direct);    
        disp(['Investment Shares = ' num2str(inv_share_check)])
        if inv_share_check > 1e-6
            warning('Inaccuracy in Investment Shares')
            pause;
        end
    
    
        % -- Material Input Shares -- %
        mat_input_shares_model          = NaN(nS,nS);
        Phi_model_direct                = NaN(nS,nS);
        for j = 1:nS
            for i = 1:nS
                Phi_model_direct(i,j) = py(i)*mij(i,j)/pm(j)/m(j);
            end
            for i = ind1_mat
                mkj = sum(eta_m(ind1_mat,j).*mij(ind1_mat,j).^((epsilon_m(j)-1)/epsilon_m(j))).^(epsilon_m(j)/(epsilon_m(j)-1));
                mat_input_shares_model(i,j)  = mkj^((1-epsilon_m(j))/epsilon_m(j))*mij(i,j)^((epsilon_m(j)-1)/epsilon_m(j))*eta_m(i,j)*rho_m(j);
            end
            for i = ind2_mat
                mat_input_shares_model(i,j)  = zeta_m(i,j)*(1-rho_m(j));
            end
        end
        mat_share_check = norm(mat_input_shares_model-Phi_model_direct);    
        disp(['Material Shares = ' num2str(mat_share_check)])
        if mat_share_check > 1e-6
            warning('Inaccuracy in Material Shares')
            pause;
        end
        
        
        % -- Value Added Shares -- %
        va_shares_model         = NaN(nS,1);
        gamma_model_direct  = NaN(nS,1);
        for j = 1:nS
            gamma_model_direct(j) = pv(j)*v(j)/py(j)/y(j);
        end
        for j = 1:nS
            va_shares_model(j)  = gamma_y(j);
        end
        va_share_check = norm(va_shares_model-gamma_model_direct);    
        disp(['Value Added Shares in Gross Output = ' num2str(va_share_check)])
        if va_share_check > 1e-6
            warning('Inaccuracy in Value Added Shares in Gross Output')
            pause;
        end
    
        
        % -- Consumption Shares -- %
        s_c = step19solver(cn,Theta_c,py,ind2_c,epsilon_c,sigma,rho);
        
        con_shares_model         = NaN(nS,1);
        theta_model_direct  = NaN(nS,1);
        for j = 1:nS
            theta_model_direct(j) = py(j)*c(j)/e;
        end
        for j = ind1_c
            con_shares_model(j) = zeta_c(j)*s_c;
        end
        omegac = zeros(nS,1);        
        for j = ind2_c(2:end)
            pyb = py(ind2_c(1));        % 
            En = sum(py(ind2_c).*c(ind2_c));
            fun = @(omega) Theta_c(j)*(py(j)/pyb)^(1-sigma)*(En/pyb)^((1-sigma)*(epsilon_c(j)-1))*(1-omega)^(epsilon_c(j)) - omega;
            omegac(j) = fsolve(fun,.2,options);
            con_shares_model(j) = omegac(j)*(1-s_c);
        end        
        for j = ind2_c(1)
            omegac(j) = 1 - sum(omegac);
            con_shares_model(j) = omegac(j)*(1-s_c);
        end
        con_share_check = norm(con_shares_model-theta_model_direct);    
        disp(['Consumption Shares = ' num2str(con_share_check)])
        % if con_share_check > 1e-6
        %     warning('Inaccuracy in Consumption Shares')
        %     pause;
        % end
    
        % Government and Net Exports
        psix_model_direct   = px.*x./(pv.*v);
        
        % -- Data vs Model Comparisons -- %
        disp(' ')
        disp(' ')
        disp('Data vs Model Comparison:')
        % Prices
        py_norm = py./py(4);
        disp('Trend Prices')
        disp('      Data    Model   Model with NDG as numeraire')    
        disp([trend_py(tt,:)'/trend_py(tt,4) py py_norm])
    
        % Value Added Shares
        %trend_va_shares_data = trend_sv(tt,:)'*100;
        eta_psi = ((eye(nS) - Phi_model_direct*(eye(nS)-diag(gamma_model_direct)))*inv(diag(gamma_model_direct)) - Omega_model_direct*diag(psix_model_direct)   - diag(psi))\theta_model_direct; %#ok<*MINV>
        va_shares_model_psi = (eta_psi/sum(eta_psi))*100;
        %disp('Trend Value Added Shares')
        %disp('      Data    Model')
        %disp([trend_va_shares_data va_shares_model_psi])
        
        va_share_model(:,tt,counter_type) = va_shares_model_psi/100;
        %va_share_data(:,tt,counter_type) = trend_va_shares_data/100;
        theta_model(:,tt,counter_type) = theta_model_direct';
        Phi_model(:,:,tt,counter_type) = Phi_model_direct;
        gamma_model(:,tt,counter_type) = gamma_model_direct';
        Omega_model(:,:,tt,counter_type) = Omega_model_direct;
        psix_model(:,tt,counter_type) = psix_model_direct';
        psi_model(:,tt,counter_type) = psi';
        py_model(:,tt,counter_type) = py';
        pv_model(:,tt,counter_type) = pv';
        v_model(:,tt,counter_type) = v';
        l_model(:,tt,counter_type) = l';


        py_lambda_guess = [py' lambda];

        disp(' ')
        disp(' ')
        disp(' ')
        disp('-----------------')

    end
    toc
end



% -- Model Results -- %


figure('Units','Inches','Position',[1 1 3 2]);
ii = 4;
hold on
plot(years, theta_model(ii,:,1),'-k','LineWidth',3)
plot(years, theta_model(ii,:,7),':','Color',rgb('Green'),'LineWidth',1)
plot(years, theta_model(ii,:,2),':','Color',rgb('Salmon'),'LineWidth',2)
plot(years, theta_model(ii,:,3),'--','Color',rgb('IndianRed'),'LineWidth',2)
plot(years, theta_model(ii,:,4),'-.','Color',rgb('HotPink'),'LineWidth',2)
plot(years, theta_model(ii,:,5),'-','Color',rgb('Tomato'),'LineWidth',1)
plot(years, theta_model(ii,:,6),'-','Color',rgb('Blue'),'LineWidth',2)    
hold off
grid on
box on
% title(SecName{ii},'FontSize',ax_fs);
% legend('No Change','TFP (Hom. Pref.)','TFP','TFP+IBTC','TFP+IBTC+Pref','TFP+IBTC+Pref+Labor','All','Location','SouthWest','FontSize',leg_fs);
% ylim(ylim1);
% ax = gca;
% ax.FontSize = ax_fs;
print('-depsc',[figdir 'Figure_11_1'])

figure('Units','Inches','Position',[1 1 3 2]);
ii = 5;
hold on
plot(years, theta_model(ii,:,1),'-k','LineWidth',3)
plot(years, theta_model(ii,:,7),':','Color',rgb('Green'),'LineWidth',1)
plot(years, theta_model(ii,:,2),':','Color',rgb('Salmon'),'LineWidth',2)
plot(years, theta_model(ii,:,3),'--','Color',rgb('IndianRed'),'LineWidth',2)
plot(years, theta_model(ii,:,4),'-.','Color',rgb('HotPink'),'LineWidth',2)
plot(years, theta_model(ii,:,5),'-','Color',rgb('Tomato'),'LineWidth',1)
plot(years, theta_model(ii,:,6),'-','Color',rgb('Blue'),'LineWidth',2)    
hold off
grid on
box on
% title(SecName{ii},'FontSize',ax_fs);
% ylim(ylim1);
% ax = gca;
% ax.FontSize = ax_fs;
print('-depsc',[figdir 'Figure_11_2'])





i_loc = [3 1 2 4 5];

for ii = 1:nS
    figure('Units','Inches','Position',[1 1 2 2]);
    hold on
    plot(years, va_share_model(ii,:,1),'-k','LineWidth',3)
    plot(years, va_share_model(ii,:,7),':','Color',rgb('Green'),'LineWidth',1)
    plot(years, va_share_model(ii,:,2),':','Color',rgb('Salmon'),'LineWidth',3)
    plot(years, va_share_model(ii,:,3),'--','Color',rgb('IndianRed'),'LineWidth',2)
    plot(years, va_share_model(ii,:,4),'-.','Color',rgb('HotPink'),'LineWidth',2)
    plot(years, va_share_model(ii,:,5),'-','Color',rgb('Tomato'),'LineWidth',1)
    plot(years, va_share_model(ii,:,6),'-','Color',rgb('Blue'),'LineWidth',2)
    if ii == 1
        ylim([0 0.1])
    elseif ii == 2 || ii == 3
        % ylim([0.05 0.15])
    end
    hold off
    grid on
    box on
    % title(char(SecName(ii)),'FontSize',ax_fs);
    % if i_loc(ii) == 1
    %     legend('No Change','TFP (Hom. Pref.)','TFP','TFP+IBTC','TFP+IBTC+Pref','TFP+IBTC+Pref+Labor','All','Location','NorthWest','FontSize',leg_fs);
    % end
    % ax = gca;
    % ax.FontSize = ax_fs;
    print('-depsc',[figdir 'Figure_12_' num2str(i_loc(ii))])
end

figure('Units','Inches','Position',[1 1 2 2]);
    hold on
    plot(years, sum(va_share_model(1:3,:,1)),'-k','LineWidth',3)
    plot(years, sum(va_share_model(1:3,:,7)),':','Color',rgb('Green'),'LineWidth',1)
    plot(years, sum(va_share_model(1:3,:,2)),':','Color',rgb('Salmon'),'LineWidth',3)
    plot(years, sum(va_share_model(1:3,:,3)),'--','Color',rgb('IndianRed'),'LineWidth',2)
    plot(years, sum(va_share_model(1:3,:,4)),'-.','Color',rgb('HotPink'),'LineWidth',2)
    plot(years, sum(va_share_model(1:3,:,5)),'-','Color',rgb('Tomato'),'LineWidth',1)
    plot(years, sum(va_share_model(1:3,:,6)),'-','Color',rgb('Blue'),'LineWidth',2)
    hold off
    grid on
    box on
    % title('Const+Durables+IPP','FontSize',ax_fs);
    % ax = gca;
    % ax.FontSize = ax_fs;
    ylim([0 0.5]);
    print('-depsc',[figdir 'Figure_12_6'])
    % fname = ['Figure_12'];
    % figure_to_png(figdir,fname);
    % close(fig); 





function s_c = step19solver(cn,omega,py,ind2,epsilon,sigma,rho)
    num= sum(epsilon(ind2).*omega(ind2).*py(ind2).^(1-sigma).*cn.^(epsilon(ind2)*(1-sigma)));
    den= sum(omega(ind2).*py(ind2).^(1-sigma).*cn.^(epsilon(ind2)*(1-sigma)));
    eta =num/den;
    s_c =rho*eta/(1-rho*(1-eta));
end